<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_outputs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->decimal('quantity', 10, 2);
            $table->foreignId('output_by_user_id')->constrained('users')->onDelete('cascade'); // User who initiated the output
            $table->foreignId('output_to_user_id')->nullable()->constrained('users')->onDelete('set null'); // User who received the stock (seller/storekeeper)
            $table->text('reason')->nullable(); // e.g., "Sold to customer", "Transferred to Seller X"
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_outputs');
    }
};