<?php 

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('unit'); // e.g., kg, g, pieces, packages, amount, boxes
            $table->decimal('input_price_per_unit', 10, 2);
            $table->decimal('selling_price_per_unit', 10, 2);
            $table->decimal('quantity', 10, 2)->default(0); // Current stock quantity
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};