<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Gate; // Hakikisha hii ipo
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Event;
use Illuminate\Auth\Events\Login; // Hakikisha hii ipo
use App\Listeners\LogSuccessfulLogin; // Hakikisha hii ipo
use App\Models\User;
use App\Models\StockInput; // Hii inaonekana haihitajiki hapa kwa gates
use App\Enums\UserRole; // Hakikisha hii ipo na inatumika

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // --- EXISTING GATES ---
        // Admin abilities
        Gate::define('is-admin', function (User $user) {
            return $user->role === UserRole::ADMIN->value;
        });

        // Storekeeper abilities
        Gate::define('is-storekeeper', function (User $user) {
            return $user->role === UserRole::STOREKEEPER->value;
        });

        // Seller abilities
        Gate::define('is-seller', function (User $user) {
            return $user->role === UserRole::SELLER->value;
        });

        // General abilities that multiple roles might share
        Gate::define('manage-stock', function (User $user) {
            return $user->role === UserRole::ADMIN->value || $user->role === UserRole::STOREKEEPER->value;
        });

        Gate::define('manage-all-stock-output', function (User $user) {
            return $user->role === UserRole::ADMIN->value;
        });

        Gate::define('manage-stock-output', function (User $user) {
            return $user->role === UserRole::ADMIN->value || $user->role === UserRole::STOREKEEPER->value;
        });

        Gate::define('track-stock', function (User $user) {
            return $user->role === UserRole::ADMIN->value || $user->role === UserRole::STOREKEEPER->value;
        });

        Gate::define('sell-stock', function (User $user) {
            return $user->role === UserRole::ADMIN->value || $user->role === UserRole::STOREKEEPER->value || $user->role === UserRole::SELLER->value;
        });

        // Specific to Admin: Manage other users
        Gate::define('manage-users', function (User $user) {
            return $user->role === UserRole::ADMIN->value;
        });
        // --- END EXISTING GATES ---


        // --- NEW/CORRECTED GATES FOR LOGIN HISTORY ---
        Gate::define('view-my-login-history', function (User $user) {
            // Any authenticated user can view their own login history.
            // No need to check specific role, as long as they are logged in.
            return true;
        });

        Gate::define('view-all-login-history', function (User $user) {
            // Only admin users can view all login history.
            return $user->role === UserRole::ADMIN->value;
        });
        // --- END NEW/CORRECTED GATES ---

        // Listener kwa ajili ya login
        Event::listen(
            Login::class,
            [LogSuccessfulLogin::class, 'handle']
        );
    }
}