<?php

namespace App\Notifications;

use App\Models\User; 
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Messages\DatabaseMessage; 

class UserRegisteredNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $newUser;
    public $adminUser;

    /**
     * Create a new notification instance.
     */
    public function __construct(User $newUser, User $adminUser)
    {
        $this->newUser = $newUser;
        $this->adminUser = $adminUser;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        // Tutatuma kupitia email na database
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->subject('User Account Registered Successfully')
                    ->greeting('Hello ' . $notifiable->name . ',')
                    ->line("A new user account for **{$this->newUser->name}** ({$this->newUser->email}) with the role **'{$this->newUser->role}'** has been successfully registered by **{$this->adminUser->name}**.")
                    ->action('View Users', url('admin/users')) // Badilisha URL kulingana na route yako ya kuonyesha users
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification for database storage.
     *
     * @return array<string, mixed>
     */
    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'user_registered',
            'new_user_id' => $this->newUser->id,
            'new_user_name' => $this->newUser->name,
            'new_user_email' => $this->newUser->email,
            'new_user_role' => $this->newUser->role,
            'registered_by_admin_id' => $this->adminUser->id,
            'registered_by_admin_name' => $this->adminUser->name,
            'message' => "New user '{$this->newUser->name}' ({$this->newUser->role}) registered by {$this->adminUser->name}.",
            'link' => url('/users/' . $this->newUser->id), // Kiungo cha kuangalia user details
        ];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
             'title' => 'New User Registered',
             'message' => "User {$this->newUser->name} ({$this->newUser->email}) has been registered by {$this->registeredByAdmin->name}.",
             'user_id' => $this->newUser->id,
        ];
    }
}