<?php

namespace App\Notifications;

use App\Models\User;
use App\Models\Product;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Messages\DatabaseMessage;

class StockDeletedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $productName;
    public $deletedByUser;

    /**
     * Create a new notification instance.
     */
    public function __construct($productName, User $deletedByUser)
    {
        $this->productName = $productName;
        $this->deletedByUser = $deletedByUser;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->subject('Product Stock Deleted')
                    ->greeting('Hello ' . $notifiable->name . ',')
                    ->line("The product **{$this->productName}** has been deleted from the system by **{$this->deletedByUser->name}** ({$this->deletedByUser->role}).")
                    ->line('Please review your stock records.');
    }

    /**
     * Get the array representation of the notification for database storage.
     *
     * @return array<string, mixed>
     */
    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'product_deleted',
            'product_name' => $this->productName,
            'deleted_by_user_id' => $this->deletedByUser->id,
            'deleted_by_user_name' => $this->deletedByUser->name,
            'message' => "Product '{$this->productName}' deleted by {$this->deletedByUser->name}.",
            'link' => url('/products'), // Au kiungo cha ripoti ya bidhaa zilizofutwa
        ];
    }
}