<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Messages\DatabaseMessage;
use Carbon\Carbon;

class SalaryPaymentReminderNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $currentMonth = Carbon::now()->format('F Y');
        return (new MailMessage)
                    ->subject("Salary Payment Reminder for {$currentMonth}")
                    ->greeting('Hello ' . $notifiable->name . ',')
                    ->line("This is a friendly reminder that salary payments for the month of **{$currentMonth}** are due soon (between 26th and 30th).")
                    ->line("Please ensure all employee salaries are processed in time.")
                    ->action('Manage Salary Payments', url('/salaries/create'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification for database storage.
     *
     * @return array<string, mixed>
     */
    public function toDatabase(object $notifiable): array
    {
        $currentMonth = Carbon::now()->format('F Y');
        return [
            'type' => 'salary_reminder',
            'month' => $currentMonth,
            'message' => "Reminder: Salary payments for {$currentMonth} are due soon.",
            'link' => url('/salaries/create'),
        ];
    }
}