<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockOutput extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'quantity',
        'output_by_user_id',
        'output_to_user_id',
        'reason',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function outputByUser()
    {
        return $this->belongsTo(User::class, 'output_by_user_id');
    }

    public function outputToUser()
    {
        return $this->belongsTo(User::class, 'output_to_user_id');
    }
}