<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleReturn extends Model
{
    use HasFactory;

    protected $fillable = [
        'sale_id',
        'product_id',
        'quantity',
        'refund_amount',
        'reason',
        'returned_by_user_id',
        'return_date',
    ];

    protected $casts = [
        'return_date' => 'datetime',
    ];

    // Relational methods
    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function returnedBy()
    {
        return $this->belongsTo(User::class, 'returned_by_user_id');
    }

    // You might add a static method for creating a sale return
    public static function createReturn(array $data)
    {
        // Example: Add logic to update product quantity back to stock
        $product = Product::find($data['product_id']);
        if ($product) {
            $product->quantity += $data['quantity'];
            $product->save();
        }

        return self::create($data);
    }
}