<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'customer_id',
        'sold_by_user_id',
        'quantity',
        'selling_price_per_unit',
        'total_price',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function soldBy()
    {
        return $this->belongsTo(User::class, 'sold_by_user_id');
    }

    public static function createSale($data)
    {
        $product = Product::findOrFail($data['product_id']);
        $customer = Customer::firstOrCreate(
            ['username' => $data['customer_username']],
            ['phone_number' => $data['customer_phone_number'] ?? null]
        );

        $totalPrice = $data['quantity'] * $product->selling_price_per_unit;

        $sale = self::create([
            'product_id' => $product->id,
            'customer_id' => $customer->id,
            'sold_by_user_id' => auth()->id(),
            'quantity' => $data['quantity'],
            'selling_price_per_unit' => $product->selling_price_per_unit,
            'total_price' => $totalPrice,
        ]);

        // For admin/storekeeper, deduct from main stock
        if (auth()->user()->role !== 'seller') {
            $product->quantity -= $data['quantity'];
            $product->save();
        }

        return $sale;
    }
    
}