<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalaryPayment extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'amount',
        'payment_date',
        'payment_period',
    ];

    /**
     * Get the user that received the salary payment.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
