<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseReturn extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'quantity',
        'refund_received_amount',
        'reason',
        'returned_by_user_id',
        'return_date',
    ];

    protected $casts = [
        'return_date' => 'datetime',
    ];

    // Relational methods
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function returnedBy()
    {
        return $this->belongsTo(User::class, 'returned_by_user_id');
    }

    // You might add a static method for creating a purchase return
    public static function createReturn(array $data)
    {
        // Example: Add logic to update product quantity from stock
        $product = Product::find($data['product_id']);
        if ($product) {
            $product->quantity -= $data['quantity']; // Quantity decreases when returned to supplier
            $product->save();
        }

        return self::create($data);
    }
}