<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CapitalEntry extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', // User aliyerekodi muamala huu
        'type',    // 'injection' (kuingiza), 'withdrawal' (kutoa)
        'amount',
        'description',
        'entry_date',
    ];

    protected $casts = [
        'entry_date' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}