<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class FixedAssetController extends Controller
{
     public function __construct()
    {
        $this->middleware(['auth', 'can:is-admin']);
    }

    public function index()
    {
        $assets = FixedAsset::all();
        return view('fixed_assets.index', compact('assets'));
    }

    public function create()
    {
        return view('fixed_assets.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'category' => 'required|string|max:255',
            'purchase_date' => 'required|date',
            'purchase_cost' => 'required|numeric|min:0',
            'current_value' => 'required|numeric|min:0',
            'depreciation_rate' => 'nullable|numeric|min:0|max:100',
            'description' => 'nullable|string',
        ]);

        FixedAsset::create($validated);

        return redirect()->route('fixed-assets.index')
            ->with('success', 'Fixed asset added successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
