<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\StockOutput;
use App\Models\Sale;
use Illuminate\Support\Facades\Gate;

class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    // Admin Dashboard
   public function admin()
{
    if (!Gate::allows('is-admin')) {
        abort(403, 'Unauthorized action.');
    }

    $products = Product::all();
    $stockOutputs = StockOutput::with(['product', 'outputToUser'])->latest()->take(5)->get();
    $sales = Sale::with(['product', 'customer'])->latest()->take(5)->get();
    $lowStockProducts = Product::where('quantity', '<', 10)->get();
    $totalCustomers = \App\Models\Customer::count();
    $totalSalesAmount = Sale::sum('total_price');
    $totalSalesCount = Sale::count();

    return view('admin.dashboard', compact(
        'products', 
        'stockOutputs', 
        'sales', 
        'lowStockProducts',
        'totalCustomers',
        'totalSalesAmount',
        'totalSalesCount'
    ));
}

    // Storekeeper Dashboard
    public function storekeeper()
    {
        if (!Gate::allows('is-storekeeper')) {
            abort(403, 'Unauthorized action.');
        }

        $products = Product::all();
        $stockOutputs = StockOutput::with(['product', 'outputToUser'])
            ->where('output_by_user_id', auth()->id())
            ->orWhere('output_to_user_id', auth()->id())
            ->latest()
            ->take(5)
            ->get();
            
        $sales = Sale::with(['product', 'customer'])->latest()->take(5)->get();
        $lowStockProducts = Product::where('quantity', '<', 10)->get();

        return view('storekeeper.dashboard', compact('products', 'stockOutputs', 'sales', 'lowStockProducts'));
    }

    // Seller Dashboard
    public function seller()
    {
        if (!Gate::allows('is-seller')) {
            abort(403, 'Unauthorized action.');
        }

        $sales = Sale::where('sold_by_user_id', auth()->id())
            ->with(['product', 'customer'])
            ->latest()
            ->take(5)
            ->get();
            
        return view('seller.dashboard', compact('sales'));
    }
}