<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use Illuminate\Support\Facades\Gate;

class CustomerController extends Controller
{
    public function index()
    {
        if (!Gate::allows('is-admin')) {
            abort(403, 'Unauthorized action.');
        }

        $customers = Customer::withCount('sales')
            ->withSum('sales', 'total_price')
            ->orderByDesc('sales_sum_total_price')
            ->paginate(10);

        return view('customers.index', compact('customers'));
    }
}